/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.utils.AABBUtils;
import mod.chiselsandbits.utils.DirectionUtils;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class AABBCompressor {
    private AABBCompressor() {
        throw new IllegalStateException("Can not instantiate an instance of: AABBCompressor. This is a utility class");
    }

    public static List<class_238> compressStates(IAreaAccessor accessor, final CollisionType sizeType) {
        final BuildingState state = new BuildingState();
        accessor.forEachWithPositionMutator(IPositionMutator.xyz(), new Consumer<IStateEntryInfo>(){

            @Override
            public void accept(IStateEntryInfo stateEntryInfo) {
                if (state.getRegionBuildingAxisValue() != stateEntryInfo.getStartPoint().method_10216()) {
                    state.setCurrentBox(null, null);
                }
                state.setRegionBuildingAxisValue(stateEntryInfo.getStartPoint().method_10216());
                if (state.getFaceBuildingAxisValue() != stateEntryInfo.getStartPoint().method_10214()) {
                    state.setCurrentBox(null, null);
                }
                state.setFaceBuildingAxisValue(stateEntryInfo.getStartPoint().method_10214());
                Optional<class_243> previousCenterPoint = state.getLastCenter();
                class_243 centerPoint = stateEntryInfo.getCenterPoint();
                state.onNextEntry(centerPoint);
                Optional<Boolean> stepDirection = previousCenterPoint.flatMap(d -> DirectionUtils.getDirectionVectorBetweenIfAligned(centerPoint, d));
                Optional<class_238> potentialEntryData = AABBCompressor.buildBoundingBox(stateEntryInfo, sizeType);
                if (potentialEntryData.isEmpty()) {
                    state.setCurrentBox(null, centerPoint);
                    return;
                }
                class_238 entryData = potentialEntryData.get();
                if (state.getCurrentBox() != null && stepDirection.map(direction -> AABBUtils.areBoxesNeighbors(state.getCurrentBox(), entryData, direction)).filter(b -> b).isPresent()) {
                    state.expandCurrentBoxToInclude(entryData, centerPoint);
                    if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, state.getCurrentBox())) {
                        return;
                    }
                    return;
                }
                if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, entryData)) {
                    return;
                }
                state.setCurrentBox(potentialEntryData.get(), centerPoint);
            }
        });
        return Lists.newArrayList(state.getBoxes());
    }

    private static boolean attemptMergeWithNeighbors(BuildingState state, class_243 centerPoint, class_238 entryData) {
        for (class_2350 offsetDirection : class_2350.values()) {
            class_238 neighborBox;
            class_243 neighborCenter = centerPoint.method_1019(class_243.method_24954((class_2382)offsetDirection.method_10163()).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            Optional<class_238> potentialNeighborBox = state.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !AABBUtils.areBoxesNeighbors(entryData, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            state.expandBoxAt(neighborCenter, entryData, centerPoint);
            return true;
        }
        return false;
    }

    public static Optional<class_238> buildBoundingBox(IStateEntryInfo stateEntryInfo, CollisionType sizeType) {
        if (!sizeType.isValidFor(stateEntryInfo)) {
            return Optional.empty();
        }
        return Optional.of(stateEntryInfo.getBoundingBox());
    }

    private static final class BuildingState {
        private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
        private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
        private class_243 lastCenterPoint = null;
        private class_238 currentBox;
        private final Map<class_243, class_238> boxAssignments = Maps.newHashMap();
        private final Multimap<class_238, class_243> stateAssignments = HashMultimap.create();

        private BuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public class_238 getCurrentBox() {
            return this.currentBox;
        }

        public void setCurrentBox(class_238 currentBox, class_243 centerPoint) {
            this.currentBox = currentBox;
            if (currentBox != null) {
                this.boxAssignments.put(centerPoint, currentBox);
                this.stateAssignments.put((Object)currentBox, (Object)centerPoint);
            }
        }

        public Optional<class_238> getBoxFor(class_243 target) {
            return Optional.ofNullable(this.boxAssignments.get(target));
        }

        public Optional<class_243> getLastCenter() {
            return Optional.ofNullable(this.lastCenterPoint);
        }

        public void onNextEntry(class_243 lastCenterPoint) {
            this.lastCenterPoint = lastCenterPoint;
        }

        public void expandCurrentBoxToInclude(class_238 entryData, class_243 centerPoint) {
            class_238 current = this.getCurrentBox();
            if (current == null) {
                throw new IllegalStateException("Can not expand current box, if current is not set.");
            }
            class_238 expanded = current.method_991(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((class_243)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
            this.currentBox = expanded;
        }

        public Collection<class_238> getBoxes() {
            return this.stateAssignments.keySet();
        }

        public void expandBoxAt(class_243 neighborCenter, class_238 entryData, class_243 centerPoint) {
            class_238 current = this.boxAssignments.get(neighborCenter);
            if (current == null) {
                throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
            }
            class_238 expanded = current.method_991(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((class_243)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
        }
    }
}

